*
*	  DOSIM_COMPUTATIONAL_COMPARISON_PROJECT.F
*	  PROGRAM TO SIMULATE A TIME SERIES WITH A CONTINUUM OF AGENTS
*         USING A SPLINE FOR THE CDF, AND DZBREN IMSL SUBROUTINE
*
*
*	  The cross-sectional distribution of beginning-of-period capital holdings consists of
*	  1. fraction of unemployed agents at the constraint
*	  2. fraction of   employed agents at the constraint
*         3. density of capital holdings of unemployed agents with positive capital
*         4. density of capital holdings of   employed agents with positive capital
*      
*         Use Dzbren IMSL subroutine which calculates the level of capital holdings at which the agent
*         chooses kappa_i
*
*        OUTPUT:
*
*        stat_dist.new, beginning-of-period moments for employed,and unemployed
*                       including the fraction at the constraint, the 5th and 10th
*                       and percentile of the cross-sectional distribution
*
*
*	12/09/2007 07:28

*
*	 !!! this program needs IMSL
*

      implicit real*8(a-h,o-z),integer(i-n)
      parameter (npar=729,nitime=10000,nkpts=992)

      real*4 secnds                             


      common/state/   stu(1000,10),stbar(10,2),st(1000,10)
      common/rpar/    blow,bhigh,emlow,emhigh
      common/ipar/    i1max,i3max,i4max,i5max,i6max,
     &  i7max,i8max,is1max,is3max,is4max,
     &  is5max,is6max,is7max,is8max,imax	
      common/par/     bbbb,gam,alpha,delta
      common/prob/    probf(2,2,2,2)
      common/coefind/ aold(8,npar)
      common/histogram/ xkpts(nkpts),dens(nkpts,2)
      common/shockdist/ nshock(nitime+1),indshock(nitime+1)

      dimension toppct(2),topse(2),topsu(2)

      t = secnds(0.0)


***********************************************************************************************

*	 i. read the parameters of the policy function. these are made available to the function bfunc(*) by
*         putting them in a common block

      open(33,file='bigcoef.new',status='unknown')
      read(33,*) ((aold(i,j),j=1,npar),i=1,8)

*	 ii. specify a lower bound "blow" and an upper bound "bhigh"

        blow   = 0.0
        bhigh  = 99.0

*	 iii. specify the parameter values, and the lower and upper bound of each 
*      aggregate state variable

	open(34,file='bigpar.b33',status='unknown')
        read(34,*) i1max,i3max,i4max,i5max,i6max,
     &  i7max,is1max,is3max,is4max,
     &  is5max,is6max,is7max,
     &  emlow,emhigh,bbbb,gam,alpha,delta,eps1,eps2,
     &  bl5,bu5,bl6,bu6,pclow,pchigh

	stu(1,2) = 0.00D+00
	stu(2,2) = 1.00D+00
	stu(1,3) = 0.99D+00        
	stu(2,3) = 1.01D+00
	stu(1,4) = 0.99D+00        
	stu(2,4) = 1.01D+00
	stu(1,8) = emlow
	stu(2,8) = emhigh
		
	stbar(1,1) = blow
	stbar(1,2) = bhigh	
	stbar(2,1) = stu(1,2)
	stbar(2,2) = stu(2,2)
	stbar(3,1) = stu(1,3)
	stbar(3,2) = stu(2,3)
	stbar(4,1) = stu(1,4)
	stbar(4,2) = stu(2,4)
	stbar(5,1) = bl5
	stbar(5,2) = bu5
	stbar(6,1) = bl6
	stbar(6,2) = bu6
	stbar(7,1) = pclow
	stbar(7,2) = pchigh
	     
*       iv. Transition probabilities
      
	open(35,file='trans.txt',status='unknown')
        read(35,*) probf(1,1,1,1),probf(1,1,1,2),probf(1,1,2,1),
     &             probf(1,1,2,2)
        read(35,*) probf(1,2,1,1),probf(1,2,1,2),probf(1,2,2,1),
     &             probf(1,2,2,2)
        read(35,*) probf(2,1,1,1),probf(2,1,1,2),probf(2,1,2,1),
     &             probf(2,1,2,2)
        read(35,*) probf(2,2,1,1),probf(2,2,1,2),probf(2,2,2,1),
     &             probf(2,2,2,2)     

*       v. Realizations of aggregate shocks(Given by Wouter)

        open(36,file='agg_switch.txt',status='unknown')
        read(36,*) (nshock(i),i=1,nitime+1)

*       vi. Realizations of individual shock consistent with aggregate shock file given above
*         (Given by Wouter)

         open(37,file='ind_switch.txt',status='unknown')
         read(37,*) (indshock(i),i=1,nitime+1)

*	vii. The initial distribution of wealth for employed and unemployed agents
*           (Given by Wouter)

	open(38,file='distwealth.txt',status='unknown')
        do 44 i = 1,nkpts
           read(38,*) xkpts(i),dens(i,1),dens(i,2)
44     continue                 
	      
*	 and the implied moments corresponding to these distributions

	call moments(nshock(1),zm1_u,zm1_e,zm2_u,zm2_e,
     &zm3_u,zm3_e,zm4_u,zm4_e,zm5_u,zm5_e)

*       stat for the first period (mmts and percentiles)

        zm2_u = (zm2_u**0.5)
        zm2_e = (zm2_e**0.5)
        zm3_u = (zm3_u**0.33333)
        zm3_e = (zm3_e**0.33333)
        zm4_u = (zm4_u**0.25)
        zm4_e = (zm4_e**0.25)
        zm5_u = (zm5_u**0.20)
        zm5_e = (zm5_e**0.20)

        open(81,file='stat_mmts.new',status='unknown')
	write(81,351) 1,nshock(1),zm1_u,zm2_u,zm3_u,zm4_u,
     &zm5_u,zm1_e,zm2_e,zm3_e,zm4_e,zm5_e
351         format(2i5,10f10.6)            	

        zpcub = dens(1,1)	

        toppct(1) = 0.05D+00
        toppct(2) = 0.10D+00
        call getpertype(2,toppct,topse)
        per05_emp   = topse(1)
        per10_emp   = topse(2)
      
        call getpertype(1,toppct,topsu)
        per05_unemp   = topsu(1)
        per10_unemp   = topsu(2)              

*
*      SIMULATION
*

	zm1_u  = zm1_u/(1.-dens(1,1))
	zm1_e  = zm1_e/(1.-dens(1,2))	      

        call       dosim(zm1_u,zm1_e,zpcub)

	t = secnds(0.0) -t
	write(*,*) 'it took ',t,' seconds'

      
        stop
        end

********************************************************************************************
*
*	Individual solutions obtained with our algorithm presented in AAD JEDC (2007)
*
*	the coefficients are stored in aold. These were read in the main program and stored
*       in a common block             
*
*	The function bfunc(aindiv,itype,iaggcur) gives the individual saving, where
*		- aindiv:  the beginning-of-period capital holdings of the agent
*		- itype:   outcome idiosyncratic shock (itype=1 for unemployed and itype=2 for employed)
*		- iaggcur: outcome aggregate state (iaggcur=1 for bad state and iaggcur=2 for good state)                             
*               - iaggold: outcome of last period aggregate state 
*                          (iaggold=1 for bad state and iaggold=2 for good state)
*               - avemp  : mean of the strictly positive capital holding of employed at the beginning-of-period
*               - avunemp: mean of the strictly positive capital holding of unemployed at the beginning-of-period
*               - pc     : fraction of agents at the constraint at the end of the previous period
*                          
********************************************************************************************


	real*8 function bfunc(aindiv,itype,iaggold,iaggcur,
     &                      avemp,avunemp,pc)
	implicit real*8(a-h,o-z),integer(i-n)
	parameter(npar=729,remp=0.15D+00)

      common/state/   stu(1000,10),stbar(10,2),st(1000,10)
      common/par/     bbbb,gam,alpha,delta
      common/rpar/    blow,bhigh,emlow,emhigh
      common/coefind/ aold(8,npar)
      common/prob/    probf(2,2,2,2)
	dimension probuu(2,2),probue(2,2),probeu(2,2),probee(2,2)

	s1     =  sca(aindiv,1)
        s5     =  sca(avemp,5)
        s6     =  sca(avunemp,6)
	s7     =  sca(pc,7)

	esca   = 1./stu(1,8)
	empl   = stu(iaggcur,8)

        do 101 icur = 1,2
	do 101 inew = 1,2
	probuu(icur,inew) = probf(icur,1,inew,1)
     &                  /(probf(icur,1,inew,1)+probf(icur,1,inew,2))
	probue(icur,inew) = probf(icur,1,inew,2)
     &                  /(probf(icur,1,inew,1)+probf(icur,1,inew,2))
	probeu(icur,inew) = probf(icur,2,inew,1)
     &                  /(probf(icur,2,inew,1)+probf(icur,2,inew,2))
	probee(icur,inew) = probf(icur,2,inew,2)
     &                  /(probf(icur,2,inew,1)+probf(icur,2,inew,2))
101	continue	      
	
	pcu    = probuu(iaggold,iaggcur)*(1.-stu(iaggold,8))*pc
	pcu    = pcu/(1.-empl)
	pce    = probue(iaggold,iaggcur)*(1.-stu(iaggold,8))*pc
	pce    = pce/empl

	caps   = empl*(1.-pce)*avemp + (1.-empl)*(1.-pcu)*avunemp
	rental = alpha*stu(iaggcur,4)*((caps/(esca*empl))**(alpha-1.))
	sal    = (1-alpha)*stu(iaggcur,4)*((caps/(esca*empl))**alpha)
     

        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     &   ivec=1            	              	
        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     &   ivec=2            	
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     &   ivec=3
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.2)) 
     &   ivec=4            	                
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     &   ivec=5            	              	
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     &   ivec=6            	
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     &   ivec=7
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.2))
     &   ivec=8            	


	expb   =  pol(s1,s5,s6,s7,ivec)
	consb  =  (expb)**(1./gam)
	bfunc  =  aindiv*(1+rental-delta) - consb + 
     &  esca*(stu(itype,2)-((stu(itype,2)/empl)-1.)*(remp/esca))*sal
     
        if(bfunc.lt.blow) then
	  bfunc  =  blow
        endif
        if(bfunc.gt.bhigh) then
	  bfunc  =  bhigh
        endif

        end

********************************************************************************************          
*
*	The function cfunc(aindiv,itype,iaggcur) gives the individual consumption, where     
*		- aindiv:  the beginning-of-period capital holdings of the agent
*		- itype:   outcome idiosyncratic shock (itype=1 for unemployed and itype=2 for employed)
*		- iaggcur: outcome aggregate state (iaggcur=1 for bad state and iaggcur=2 for good state)                             
*               - iaggold: outcome of last period aggregate state 
*                          (iaggold=1 for bad state and iaggold=2 for good state)
*               - avemp  : mean of the strictly positive capital holding of employed at the beginning-of-period
*               - avunemp: mean of the strictly positive capital holding of unemployed at the beginning-of-period
*               - pc     : fraction of agents at the constraint at the end of the previous period
*                          
********************************************************************************************

	real*8 function cfunc(aindiv,itype,iaggold,iaggcur,
     &                      avemp,avunemp,pc)
	implicit real*8(a-h,o-z),integer(i-n)
	parameter(npar=729,remp=0.15D+00)

      common/state/   stu(1000,10),stbar(10,2),st(1000,10)
      common/par/     bbbb,gam,alpha,delta
      common/rpar/    blow,bhigh,emlow,emhigh
      common/coefind/ aold(8,npar)
      common/prob/    probf(2,2,2,2)
	dimension probuu(2,2),probue(2,2),probeu(2,2),probee(2,2)

	s1     =  sca(aindiv,1)
        s5     =  sca(avemp,5)
        s6     =  sca(avunemp,6)
	s7     =  sca(pc,7)

	esca   = 1./stu(1,8)
	empl   = stu(iaggcur,8)

        do 101 icur = 1,2
	do 101 inew = 1,2
	probuu(icur,inew) = probf(icur,1,inew,1)
     &                  /(probf(icur,1,inew,1)+probf(icur,1,inew,2))
	probue(icur,inew) = probf(icur,1,inew,2)
     &                  /(probf(icur,1,inew,1)+probf(icur,1,inew,2))
	probeu(icur,inew) = probf(icur,2,inew,1)
     &                  /(probf(icur,2,inew,1)+probf(icur,2,inew,2))
	probee(icur,inew) = probf(icur,2,inew,2)
     &                  /(probf(icur,2,inew,1)+probf(icur,2,inew,2))
101	continue	      
	
	pcu    = probuu(iaggold,iaggcur)*(1.-stu(iaggold,8))*pc
	pcu    = pcu/(1.-empl)
	pce    = probue(iaggold,iaggcur)*(1.-stu(iaggold,8))*pc
	pce    = pce/empl

	caps   = empl*(1.-pce)*avemp + (1.-empl)*(1.-pcu)*avunemp
	rental = alpha*stu(iaggcur,4)*((caps/(esca*empl))**(alpha-1.))
	sal    = (1-alpha)*stu(iaggcur,4)*((caps/(esca*empl))**alpha)
     

        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     &   ivec=1            	              	
        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     &   ivec=2            	
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     &   ivec=3
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.2)) 
     &   ivec=4            	                
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     &   ivec=5            	              	
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     &   ivec=6            	
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     &   ivec=7
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.2))
     &   ivec=8            	


	expb   =  pol(s1,s5,s6,s7,ivec)
	consb  =  (expb)**(1./gam)
	bond1  =  aindiv*(1.+rental-delta) - consb + 
     &  esca*(stu(itype,2)-((stu(itype,2)/empl)-1.)*(remp/esca))*sal	
        wealth =  aindiv*(1.+rental-delta) + 
     &  esca*(stu(itype,2)-((stu(itype,2)/empl)-1.)*(remp/esca))*sal	

        if(bond1.lt.blow) then
	  bond1  =  blow
	  consb  =  wealth
        endif
        if(bond1.gt.bhigh) then
	  bond1  =  bhigh
	  consb  =  wealth - bond1
        endif

        cfunc = consb
        
        end



*
*    SIMULATION ROUTINE
*
        
      subroutine dosim(avunemp,avemp,pcu)
     
      implicit real*8(a-h,o-z),integer(i-n)
      parameter(npar=729,nitime=10000,nkpts=992,remp=0.15D+00)
      parameter(nroot=1)
     
      common/state/   stu(1000,10),stbar(10,2),st(1000,10)
      common/rpar/    blow,bhigh,emlow,emhigh
      common/par/     bbbb,gam,alpha,delta
      common/prob/    probf(2,2,2,2)
      common/coefind/ aold(8,npar)
      common/shockdist/ nshock(nitime+1),indshock(nitime+1)
      common/histogram/ xkpts(nkpts),dens(nkpts,2)
      common/istate/  itype,iaggold,iaggcur
      common/rstate/  ravemp,ravunemp,rpc,doel

      dimension emp(2),toppct(2),topse(2),topsu(2),
     $templow(2),temphigh(2),cdfend(nkpts,2),cdf(nkpts,2)
      dimension probuu(2,2),probue(2,2),probeu(2,2),probee(2,2)

      external ff
	
      do 101 icur = 1,2
	do 101 inew = 1,2
	probuu(icur,inew) = probf(icur,1,inew,1)
     &                  /(probf(icur,1,inew,1)+probf(icur,1,inew,2))
	probue(icur,inew) = probf(icur,1,inew,2)
     &                  /(probf(icur,1,inew,1)+probf(icur,1,inew,2))
	probeu(icur,inew) = probf(icur,2,inew,1)
     &                  /(probf(icur,2,inew,1)+probf(icur,2,inew,2))
	probee(icur,inew) = probf(icur,2,inew,2)
     &                  /(probf(icur,2,inew,1)+probf(icur,2,inew,2))
101	continue	      

      open(79,file='stat_indiv.new',status='unknown')
      open(80,file='stat_dist.new',status='unknown')

                                    
      esca   = 1./stu(1,8)
      
      xint = (bhigh-blow)/dble(nkpts-2)
      toppct(1) = 0.05D+00
      toppct(2) = 0.10D+00

      emp(1) = emlow
      emp(2) = emhigh

      iaggold = nshock(1)
      iaggcur = nshock(1)       

*      fraction of unemployed agent with zero capital holding at the end of the last period
*      this can also be determined using pce. But the given values of pcu & pce are actually from a
*      2 to 2 transition while here we start with a 1 to 1 transition, so would get a different answer
*      but pc is only used in the policy rule and has their minimal effect
*      

        pc    = (pcu*(1.-emp(iaggcur))/probuu(iaggold,iaggcur))
        pc    = pc/(1.-emp(iaggold))

	cdf(1,1) = dens(1,1)
	cdf(1,2) = dens(1,2)
	do 104 j = 2,nkpts
	cdf(j,1) = cdf(j-1,1)+dens(j,1)
	cdf(j,2) = cdf(j-1,2)+dens(j,2)
104	continue

*	note that cdf(nkpts-1,*) is the cdf at "bhigh - epsilon"
*       cdf(nkpts,*) is the cdf at bhigh

	ravemp = avemp
	ravunemp = avunemp
	rpc = pc

*	Agent's beginning-of-period capital stock


        cap_i = 43.00D+00
        	             
      do 448 itime = 1,nitime

      write(6,350) itime,iaggcur
      	     
      cap=(1.-dens(1,2))*emp(iaggcur)*ravemp+
     &     (1.-dens(1,1))*(1.-emp(iaggcur))*ravunemp     
      rental=alpha*stu(iaggcur,4)*
     &((cap/(esca*emp(iaggcur)))**(alpha-1.))
      sal=(1-alpha)*stu(iaggcur,4)*((cap/(esca*emp(iaggcur)))**alpha)
      gdp=stu(iaggcur,4)*(cap**alpha)*(esca*emp(iaggcur))**(1.-alpha)     

      itype = indshock(itime)
      zincom= esca*(stu(itype,2)-
     & ((stu(itype,2)/emp(iaggcur))-1.)*remp)*sal
      cap1_i=bfunc(cap_i,itype,iaggold,iaggcur,ravemp,ravunemp,rpc)
      cons_i=cfunc(cap_i,itype,iaggold,iaggcur,ravemp,ravunemp,rpc)                                 

      call getpertype(2,toppct,topse)
      per05_emp   = topse(1)
      per10_emp   = topse(2)

      call getpertype(1,toppct,topsu)
      per05_unemp = topsu(1)
      per10_unemp = topsu(2)
            
      write(79,349) itime,iaggcur,itype,cap_i,cons_i,zincom,
     &(1.-dens(1,2))*ravemp,(1.-dens(1,1))*ravunemp,rental,
     &sal,per05_emp,per10_emp,per05_unemp,per10_unemp,cap,gdp
349         format(3i5,14f10.6)

      write(80,350) itime,iaggcur,cap,gdp,rental,sal,
     &(1.-dens(1,2))*ravemp,(1.-dens(1,1))*ravunemp,
     &dens(1,2),dens(1,1),rpc,per05_emp,per10_emp,per05_unemp,
     &per10_unemp         
350         format(2i5,13f10.6)                  


	templow(1)  = bfunc(blow, 1,iaggold,iaggcur,ravemp,ravunemp,rpc)
	templow(2)  = bfunc(blow, 2,iaggold,iaggcur,ravemp,ravunemp,rpc)
	temphigh(1) = bfunc(bhigh,1,iaggold,iaggcur,ravemp,ravunemp,rpc)
	temphigh(2) = bfunc(bhigh,2,iaggold,iaggcur,ravemp,ravunemp,rpc)

*
*
*     find the individual capital stock at which the grid points are chosen
*

 	errabs = 1.0e-14
	errrel = 1.0e-14

        itype = 2
	cdfend(nkpts,itype) = 1

      do 201 j = 1,nkpts-1

	doel  = xkpts(j)
	itmax = 1000
	alow  = 0
	ahigh = 99 
	if (doel.lt.templow(itype)) then	
	    cdfend(j,itype)=0
	else
	    if (doel.gt.temphigh(itype)) then 
		cdfend(j,itype) = 1
	    else
		call dzbren(ff,errabs,errrel,alow,ahigh,itmax)
	        itemp = int4(ahigh/xint)
	        fraction = (ahigh-dble(itemp)*xint)/xint 
	        cdfend(j,itype) = cdf(itemp+1,itype)+
     &          dens(itemp+2,itype)*fraction
	    endif
	end if
 
201 	continue


	itype = 1
	doel = xkpts(1)
	alow  = 0
	ahigh = 99
	itmax = 1000
	call dzbren(ff,errabs,errrel,alow,ahigh,itmax)
	itemp = int4(ahigh/xint)
	cdfend(1,itype) = 0
	do 204 i = 1,itemp+1
	cdfend(1,itype) = cdfend(1,itype) + dens(i,itype)
204   continue
	fraction = (ahigh-dble(itemp)*xint)/xint 
	cdfend(1,itype) = cdfend(1,itype) + fraction*dens(itemp+2,itype)

	do 205 j = 2,nkpts

	doel  = xkpts(j)
	alow  = 0

	ahigh = 99
	itmax = 1000

	    if (doel.gt.temphigh(itype)) then 
	    cdfend(j,itype)=1
	else
		call dzbren(ff,errabs,errrel,alow,ahigh,itmax)
	    itemp = int4(ahigh/xint)
	    fraction = (ahigh-dble(itemp)*xint)/xint 
	    cdfend(j,itype) = cdf(itemp+1,itype)+dens(itemp+2,itype)
     &    *fraction
	end if
205	continue


*
*	update fraction of constrainted agents
*
	rpc = cdfend(1,1)


*
*	calculate next period's beginning-of-period distribution
*

	iaggnew = nshock(itime+1)

	do 301 j = 1,nkpts
	cdf(j,1) = ( probuu(iaggcur,iaggnew)*cdfend(j,1)*(1-emp(iaggcur))
     &            +probeu(iaggcur,iaggnew)*cdfend(j,2)*   emp(iaggcur) 
     &           )/(1-emp(iaggnew))
	cdf(j,2) = ( probue(iaggcur,iaggnew)*cdfend(j,1)*(1-emp(iaggcur))
     &            +probee(iaggcur,iaggnew)*cdfend(j,2)*   emp(iaggcur) 
     &           )/emp(iaggnew)
301	continue

	dens(1,1) = cdf(1,1);
	dens(1,2) = cdf(1,2);
	do 304 j = 2,nkpts
	dens(j,1) = cdf(j,1)-cdf(j-1,1);
	dens(j,2) = cdf(j,2)-cdf(j-1,2);
304	continue


*
*     calcualte next period's moments (NOT conditional on not being contrained)
*	

	call moments(iaggnew,zm1_u,zm1_e,zm2_u,zm2_e,
     &zm3_u,zm3_e,zm4_u,zm4_e,zm5_u,zm5_e)

*       Scaled higher-order moments        
        

        zm2_u = (zm2_u**0.5)
        zm2_e = (zm2_e**0.5)
        zm3_u = (zm3_u**0.33333)
        zm3_e = (zm3_e**0.33333)
        zm4_u = (zm4_u**0.25)
        zm4_e = (zm4_e**0.25)
        zm5_u = (zm5_u**0.20)
        zm5_e = (zm5_e**0.20)

*       Update
        
        iaggold   = iaggcur
        iaggcur   = iaggnew                
	ravunemp  = zm1_u/(1.-dens(1,1))
	ravemp    = zm1_e/(1.-dens(1,2))
        cap_i     = cap1_i

	write(81,351) itime+1,iaggnew,zm1_u,zm2_u,zm3_u,zm4_u,
     &zm5_u,zm1_e,zm2_e,zm3_e,zm4_e,zm5_e
351         format(2i5,10f10.6)            	
448     continue              
       
       end

	real*8 function ff(x)
	real*8 x,ravemp,ravunemp,rpc,doel,bfunc
	common/istate/  itype,iaggold,iaggcur
	common/rstate/  ravemp,ravunemp,rpc,doel

	ff = doel-bfunc(x,itype,iaggold,iaggcur,ravemp,ravunemp,rpc)

	return
	end        



	real*8 function pol(s1,s5,s6,s7,ivec)
        implicit real*8(a-h,o-z),integer(i-n)
        parameter (npar=729)
        
        common/ipar/    i1max,i3max,i4max,i5max,i6max,
     &  i7max,i8max,is1max,is3max,is4max,
     &  is5max,is6max,is7max,is8max,imax	
        common/coefind/ aold(8,npar)
             
	pol = 0.
	do 20 j1 = 1,i1max+1
	do 20 j5 = 1,i5max+1
	do 20 j6 = 1,i6max+1	
	do 20 j7 = 1,i7max+1	
	i1 = j1 - 1     
	i5 = j5 - 1     
	i6 = j6 - 1     	
	i7 = j7 - 1     	
	jj =  ipoint(i1,i5,i6,i7)
	pol =  pol + aold(ivec,jj)*hh(s1,s5,s6,s7,i1,i5,i6,i7)
20      continue

	pol = exp(pol)


        end                
        
	integer function ipoint(i1,i5,i6,i7)
	implicit real*8(a-h,o-z),integer(i-n)
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     &  i7max,i8max,is1max,is3max,is4max,
     &  is5max,is6max,is7max,is8max,imax	
	 
	ipoint = 1 + i5 
     &  + i6*(i5max+1) 
     &  + i1*(i6max+1)*(i5max+1)            
     &  + i7*(i1max+1)*(i6max+1)*(i5max+1)            
     
     
        end        


	real*8 function sca(x,i)
	implicit real*8(a-h,o-z),integer(i-n)
        common/state/ stu(1000,10),stbar(10,2),st(1000,10)
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     &  i7max,i8max,is1max,is3max,is4max,
     &  is5max,is6max,is7max,is8max,imax	

	sca =  ( 2.*x -  stbar(i,2) - stbar(i,1) ) 
     &        /  (stbar(i,2)-stbar(i,1))

	end 


	real*8 function h(x,i)
	implicit real*8(a-h,o-z),integer(i-n)
        
        dimension a(200)

	a(1) = 1.
	a(2) = x

	if(i.le.1) then
	h =  a(i+1)
	goto 99
	endif

	
	if(i.gt.1) then

	do 10 j = 2,i
	a(j+1) = 2.*x*a(j) - a(j-1)
10      continue
	h =  a(i+1)

	endif

99      continue

	end


	real*8 function hh(s1,s5,s6,s7,i1,i5,i6,i7)
	implicit real*8(a-h,o-z),integer(i-n)
	
	hh = h(s1,i1)*h(s5,i5)*h(s6,i6)*h(s7,i7)
	
	end           

*
*	moments subroutine
*


      subroutine moments(iaggcur,zm1_u,zm1_e,zm2_u,
     &zm2_e,zm3_u,zm3_e,zm4_u,zm4_e,zm5_u,zm5_e)
     
      implicit real*8(a-h,o-z),integer(i-n)
      parameter(nkpts=992)
      common/rpar/    blow,bhigh,emlow,emhigh     
      common/histogram/ xkpts(nkpts),dens(nkpts,2)

      dimension emp(2)


!	note that the first and the last cell have point mass
!     the other cells indicate mass uniformly distributed between nodes


        emp(1) = emlow
        emp(2) = emhigh   
     
	zm1_u = dens(1,1)*xkpts(1)
	zm1_e = dens(1,2)*xkpts(1)

	zm2_u = dens(1,1)*(xkpts(1)**2)
	zm2_e = dens(1,2)*(xkpts(1)**2)

	zm3_u = dens(1,1)*(xkpts(1)**3)
	zm3_e = dens(1,2)*(xkpts(1)**3)

	zm4_u = dens(1,1)*(xkpts(1)**4)
	zm4_e = dens(1,2)*(xkpts(1)**4)

	zm5_u = dens(1,1)*(xkpts(1)**5)
	zm5_e = dens(1,2)*(xkpts(1)**5)

	do 100 j = 2,nkpts-1

	zm1_u = zm1_u+dens(j,1)*0.5*(xkpts(j)+xkpts(j-1))
	zm1_e = zm1_e+dens(j,2)*0.5*(xkpts(j)+xkpts(j-1))

        zm2_u = zm2_u+dens(j,1)*(xkpts(j)**2+xkpts(j)*xkpts(j-1)+
     &xkpts(j-1)**2)/3.
        zm2_e = zm2_e+dens(j,2)*(xkpts(j)**2+xkpts(j)*xkpts(j-1)+
     &xkpts(j-1)**2)/3.     

        zm3_u = zm3_u+dens(j,1)*((xkpts(j)+xkpts(j-1))*
     &((xkpts(j)**2)+(xkpts(j-1)**2)))/4
        zm3_e = zm3_e+dens(j,2)*((xkpts(j)+xkpts(j-1))*
     &((xkpts(j)**2)+(xkpts(j-1)**2)))/4
     
        zm4_u = zm4_u+dens(j,1)*((xkpts(j)**4)+(xkpts(j)**3)*xkpts(j-1)+
     &(xkpts(j)**2)*(xkpts(j-1)**2)+xkpts(j)*(xkpts(j-1)**3)+
     &xkpts(j-1)**4)/5
        zm4_e = zm4_e+dens(j,2)*((xkpts(j)**4)+(xkpts(j)**3)*xkpts(j-1)+
     &(xkpts(j)**2)*(xkpts(j-1)**2)+xkpts(j)*(xkpts(j-1)**3)+
     &xkpts(j-1)**4)/5
     
        zm5_u = zm5_u+dens(j,1)*((xkpts(j)+xkpts(j-1))*
     &((xkpts(j)**2)+xkpts(j)*xkpts(j-1)+(xkpts(j-1)**2))*
     &((xkpts(j)**2)-xkpts(j)*xkpts(j-1)+(xkpts(j-1)**2)))/6.
        zm5_e = zm5_e+dens(j,2)*((xkpts(j)+xkpts(j-1))*
     &((xkpts(j)**2)+xkpts(j)*xkpts(j-1)+(xkpts(j-1)**2))*
     &((xkpts(j)**2)-xkpts(j)*xkpts(j-1)+(xkpts(j-1)**2)))/6.
100	continue

	zm1_u = zm1_u+dens(nkpts,1)*xkpts(nkpts)
	zm1_e = zm1_e+dens(nkpts,2)*xkpts(nkpts)
 
	zm2_u = zm2_u+dens(nkpts,1)*(xkpts(nkpts)**2)
	zm2_e = zm2_e+dens(nkpts,2)*(xkpts(nkpts)**2)

	zm3_u = zm3_u+dens(nkpts,1)*(xkpts(nkpts)**3)
	zm3_e = zm3_e+dens(nkpts,2)*(xkpts(nkpts)**3)

	zm4_u = zm4_u+dens(nkpts,1)*(xkpts(nkpts)**4)
	zm4_e = zm4_e+dens(nkpts,2)*(xkpts(nkpts)**4)

	zm5_u = zm5_u+dens(nkpts,1)*(xkpts(nkpts)**5)
	zm5_e = zm5_e+dens(nkpts,2)*(xkpts(nkpts)**5)		
	

	end


      subroutine getpertype(itype,toppct,tops)
      implicit real*8 (a-h,o-z)
      parameter (nkpts=992)
      common/histogram/ xkpts(nkpts),dens(nkpts,2)
      dimension xpt(nkpts+1),tops(2),toppct(2)
      
      nhpts = 0
      sumx  = 0.0d+00    
             
      do 89 j = 1,nkpts
         sumx = sumx+dens(j,itype)
c         if (dens(j,itype) .gt. 1.0D-10) then
            nhpts = nhpts+1
            xpt(nhpts) = sumx
c         endif

 89   continue
               
      do 10 i = 1,2
	   call splin(xpt,toppct(i),yval,hval,khi,klo,0,nhpts,itype)
	   tops(i) = yval
 10   continue

         
      end

      subroutine splin(xa,x,y,h,khi,klo,kvals,n,itype)
      implicit real*8 (a-h,o-z)
      parameter (nkpts=992)
      common/histogram/ xkpts(nkpts),dens(nkpts,2)
      dimension xa(n)

      one = 1.0D+00
      if (kvals .eq. 0) then
         klo = 1
         khi = n
 1       if ((khi-klo) .gt. 1) then
            k = (khi+klo)/2
            if (xa(k) .gt. x) then
               khi = k
            else
               klo = k
            endif
            goto 1
         endif
      endif

      h = (x-xa(klo))/dens(khi,itype)
      y = (1-h)*xkpts(klo)+h*xkpts(khi)

      return
      end
      
